function [Ui,Vi,n0,np,ixmC0Pres] = ftd_iden_MPExoOnly2(lags,nvar,nexo,indxC0Pres)
%    Exporting orthonormal matrices for the deterministic linear restrictions (equation by equation)
%    See Waggoner and Zha's Gibbs sampling paper.
%
% q_m:  quarter or month
% lags: the maximum length of lag
% nvar:  number of endogeous variables
% nexo:  number of exogenous variables.  If nexo is not supplied, nexo=1 as default for a constant
% indxC0Pres: index for cross-A0-A+ restrictions.  if 1: cross-A0-and-A+ restrictions; 0: idfile is all we have
%                Example for indxOres==1: restrictions of the form P(t) = P(t-1).
%                These restrictions have to be manually and carefully keyed in.
%-----------------
% Ui: nvar-by-1 cell.  In each cell, nvar-by-qi orthonormal basis for the null of the ith
%           equation contemporaneous restriction matrix where qi is the number of free parameters.
%           With this transformation, we have ai = Ui*bi or Ui'*ai = bi where ai is a vector
%           of total original parameters and bi is a vector of free parameters. When no
%           restrictions are imposed, we have Ui = I.  There must be at least one free
%           parameter left for the ith equation.
% Vi: nvar-by-1 cell.  In each cell, k-by-ri orthonormal basis for the null of the ith
%           equation lagged restriction matrix where k is a total of exogenous variables and
%           ri is the number of free parameters. With this transformation, we have fi = Vi*gi
%           or Vi'*fi = gi where fi is a vector of total original parameters and gi is a
%           vector of free parameters. There must be at least one free parameter left for
%           the ith equation.
% n0: nvar-by-1, ith element represents the number of free A0 parameters in ith equation
% np: nvar-by-1, ith element represents the number of free A+ parameters in ith equation
% ixmC0Pres:  neq_cres-by-1 cell.  Effective only if indxC0Pres=1, otherwise equals NaN.
%             neq_cres is the number of equations in which cross-A0-A+ restrictions occur.
%             In the jth cell representing equation, we have 4 columns:
%               1st: the jth column (equation) of A+ or A0: f_j or a_j
%               2nd: the ith element f_j(i) -- the ith element in the jth column of A+
%               3rd: the hth element a_j(h) -- the hth element in the jth column of A0
%               4th: the number s such that f_j(i) = s * a_j(h) holds.
%
% Tao Zha, April 2016
Ui = cell(nvar,1);  % initializing for contemporaneous endogenous variables
Vi = cell(nvar,1);  % initializing for lagged and exogenous variables
n0 = zeros(nvar,1); % ith element represents the number of free A0 parameters in ith equation
np = zeros(nvar,1); % ith element represents the number of free A+ parameters in ith equation

if (nargin==2)
   nexo = 1;  % 1: constant as default where nexo must be a nonnegative integer
elseif (nargin==3)
   indxC0Pres = 0;  % default is no cross-A0-and-A+ restrictions.
end
ixmC0Pres = indxC0Pres;

k = lags*nvar+nexo;  % maximum number of lagged and exogenous variables in each equation

Qi = zeros(nvar,nvar,nvar);   % for nvar contemporaneous equations
Ri = zeros(k,k,nvar);    % for nvar lagged and exogenous equations
  % Row corresponds to equation. 0 means no restriction.
  %                              1 means exclusion restriction such that the corresponding parameter is restricted to 0.

%nfvar = 6;   % number of foreign (Granger causing) variables
%nhvar = nvar-nfvar;  % number of home (affected) variables.

identityM = eye(nvar);
%Qi(2:nvar,:,1) = identityM(2:end,:);
%   for i=1:nvar-1
%       Qi(1:nvar-i,:,i)=identityM(i+1:end,:);
%   end
Qi(1:nvar-1,:,1)=identityM(2:end,:);
%
Qi(1,1,2) = 1;
%Qi(2,3,2) = 1; % With this commented out, it would be still fine. 
%
%Qi(1,2,3) = 1; % With this commented out, it would be still fine. 

%****************************************************************
%*** Lagged restrictions
%****************************************************************
loc_exovar = [1];   % location for an exogenous variable.
cnt=0;
for ki = 1:lags
   for kj= 1:nvar            
      loc_col = nvar*(ki-1)+kj;
      cnt=cnt+1;
      Ri(cnt, loc_col, loc_exovar) = 1;
   end
end
cnt = cnt+1;
Ri(cnt, nvar*lags+1, loc_exovar) = 1;   %Constant term
%-
loc_zerovar = [1]; % location for variable to be zeroed out. 
loc_eqn = [2];   % location for the equation.
cnt=0;
for ki = 1:lags
   loc_zero = nvar*(ki-1)+loc_zerovar;
   for kj= 1:nvar            
      loc_col = nvar*(ki-1)+kj;
      if (loc_col==loc_zero)
         cnt=cnt+1;
         Ri(cnt, loc_col, loc_eqn) = 1;
      end
   end
end
%-
if (0) %0: gives the best result.
loc_zerovar = [2]; % location for variable to be zeroed out. 
loc_eqn = [3];   % location for the equation.
cnt=0;
for ki = 1:lags
   loc_zero = nvar*(ki-1)+loc_zerovar;
   for kj= 1:nvar            
      loc_col = nvar*(ki-1)+kj;
      if (loc_col==loc_zero)
         cnt=cnt+1;
         Ri(cnt, loc_col, loc_eqn) = 1;
      end
   end
end
end

%--- Setting the consant to zero.
%cnt=cnt+1;
%Ri(cnt, nvar*lags+1, loc_exovar) = 1;  %Setting the constant to zero.

for n=1:nvar   %  initializing loop for each equation
   Ui{n} = null(Qi(:,:,n));
   Vi{n} = null(Ri(:,:,n));
   n0(n) = size(Ui{n},2);
   np(n) = size(Vi{n},2);
end


