%==========================================================================================%
%============================= Point Estimation of BVARs ==================================%
%==========================================================================================%
pvar_setup;

%=== Reading the identification and data
eval(['[Ui,Vi,n0,np,ixmC0Pres] = ' idfile_const '(lags,nvar,nexo,indxC0Pres);']);

mdim = lags*nvar+nexo;
%--- Nonstate banks
xtx_nonstate = zeros(mdim, mdim);
xty_nonstate = zeros(mdim, nvar);
yty_nonstate = zeros(nvar, nvar);
for (ik=1:nbanks_nonstate)
   [xtx,xty,yty,fss,phi,y,ncoef,xr,Bh] = fn_dataxy(nvar,lags,xdgel_nonstate{ik},mu,0,nexo);
   xtx_nonstate = xtx_nonstate + xtx;
   xty_nonstate = xty_nonstate + xty;
   yty_nonstate = yty_nonstate + yty;      
end
fss_nonstate = fss*nbanks_nonstate;
%--- State banks
xtx_state = zeros(mdim, mdim);
xty_state = zeros(mdim, nvar);
yty_state = zeros(nvar, nvar);
for (ik=1:nbanks_state)
   [xtx,xty,yty,fss,phi,y,ncoef,xr,Bh] = fn_dataxy(nvar,lags,xdgel_state{ik},mu,0,nexo);
   xtx_state = xtx_state + xtx;
   xty_state = xty_state + xty;
   yty_state = yty_state + yty;      
end
fss_state = fss*nbanks_state;

%=== Setting up matrices for estimation
if (indxDummy)
   %*** Obtains dummy observations prior as 1st part of an explicit prior reflected in Hpmulti and Hpinvmulti).  See Zha's Forecast II notes, pp.69a-69b for details.
   [Pi, H0multi, Hpmulti, H0invmulti, Hpinvmulti,sgh] = fn_rnrprior_covres_dobs_v2(nvar,q_m,lags,xdgel_agg,mu,indxDummy);   
   %*** Combines dummy observations prior with linear restrictions
   [Ptld, H0invtld, Hpinvtld] = fn_rlrprior(Ui,Vi,Pi,H0multi, Hpmulti, nvar);
   %*** Obtains the posterior matrices for estimation and inference
   [Pmat_nonstate, H0inv_nonstate, Hpinv_nonstate] = fn_rlrpostr(xtx_nonstate, xty_nonstate, yty_nonstate, Ptld, H0invtld, Hpinvtld, Ui,Vi);
   %-
   [Pmat_state, H0inv_state, Hpinv_state] = fn_rlrpostr(xtx_state,xty_state, yty_state, Ptld, H0invtld, Hpinvtld, Ui,Vi);
else
   %*** Obtaining the posterior matrices for estimation and inference
   [Pmat_nonstate,H0inv_nonstate,Hpinv_nonstate] = fn_dlrpostr(xtx_nonstate,xty_nonstate,yty_nonstate,Ui,Vi);
   [Pmat_state,H0inv_state,Hpinv_state] = fn_dlrpostr(xtx_state,xty_state,yty_state,Ui,Vi);
end

%======= Obtaining the posterior or maximum likelihood estimates =======
fn_reset_ini_seed(0);
x = 10*rand(sum(n0),1);
H0 = eye(sum(n0));
crit = 1.0e-8;
nit = 10000;
% --------------------- Nonstate minimization ---------------------
tic;
[fhat_nonstate, xhat_nonstate, grad, Hhat, itct, fcount, retcodehat] = ...
      csminwel('fn_a0freefun',x,H0,'fn_a0freegrad',crit,nit,Ui,nvar,n0,fss_nonstate,H0inv_nonstate);
csmiwel_computingtime = toc
A0hat_nonstate = fn_tran_b2a(xhat_nonstate,Ui,nvar,n0);
A0hat_nonstate(:, loc_MPshock) = A0hat_nonstate(:, loc_MPshock)/nbanks_nonstate;  %/nbanks_nonstate: aggregate the effects of a monetary policy shock within the nonstate banking system.
for ki=1:size(A0hat_nonstate,1)
   if A0hat_nonstate(ki,ki)<0
      A0hat_nonstate(:,ki) = -A0hat_nonstate(:,ki);
   end
end      
A0hatinv_nonstate = inv(A0hat_nonstate);
disp('------ Printing the minimization results for nonstate banks -------');
fhat_nonstate
xhat_nonstate
grad
itct
fcount
retcodehat
xhat_nonstate = fn_tran_a2b(A0hat_nonstate,Ui,nvar,n0); %Must have this line to be consistent with normalization of A0hat.
%--- Lagged coefficients
[Aphat_nonstate, ghat_nonstate] = fn_gfmean(xhat_nonstate,Pmat_nonstate,Vi,nvar,ncoef,n0,np);
Bhat_nonstate = Aphat_nonstate/A0hat_nonstate;   
%--- Computeing the roots for the whole system.
disp('------ Roots for nonstate banks -------');
rootsinv_nonstate = fn_varoots(Bhat_nonstate,nvar,lags)
disp('------ Sorted absolute roots for nonstate banks -------');
sort(abs(rootsinv_nonstate),'descend')
% --------------------- Nonstate minimization ---------------------
tic;
[fhat_state, xhat_state, grad, Hhat, itct, fcount, retcodehat] = ...
      csminwel('fn_a0freefun',x,H0,'fn_a0freegrad',crit,nit,Ui,nvar,n0,fss_state,H0inv_state);
csmiwel_computingtime = toc
A0hat_state = fn_tran_b2a(xhat_state,Ui,nvar,n0);
A0hat_state(:, loc_MPshock) = A0hat_state(:, loc_MPshock)/nbanks_state; %/nbanks_state: aggregate the effects of a monetary policy shock within the state banking system.
for ki=1:size(A0hat_state,1)
   if A0hat_state(ki,ki)<0
      A0hat_state(:,ki) = -A0hat_state(:,ki);
   end
end      
A0hatinv_state = inv(A0hat_state);
disp('------ Printing the minimization results for state banks -------');
fhat_state
xhat_state
grad
itct
fcount
retcodehat
xhat_state = fn_tran_a2b(A0hat_state,Ui,nvar,n0); %Must have this line to be consistent with normalization of A0hat.
%--- Lagged coefficients
[Aphat_state, ghat_state] = fn_gfmean(xhat_state,Pmat_state,Vi,nvar,ncoef,n0,np);
Bhat_state = Aphat_state/A0hat_state;   
%--- Computeing the roots for the whole system.
disp('------ Roots for state banks -------');
rootsinv_state = fn_varoots(Bhat_state,nvar,lags)
disp('------ Sorted absolute roots for state banks -------');
sort(abs(rootsinv_state),'descend')


%-----------------------------------------------------------
%--- Impulse responses
%-----------------------------------------------------------
%=== Nonstate banks
imfhat_nonstate = fn_impulse(Bhat_nonstate, A0hatinv_nonstate, [nvar lags imstp]);    
imf3hat_nonstate = reshape(imfhat_nonstate,size(imfhat_nonstate,1),nvar,nvar);
        % imf3: row--steps, column--nvar responses, 3rd dimension--nvar shocks        
imf3shat_nonstate = permute(imf3hat_nonstate,[1 3 2]);
        % imf3s: permuted so that row--steps, column--nvar shocks,
        %                                3rd dimension--nvar responses
        % Note: reshape(imf3s(1,:,:),nvar,nvar) = A0in  (columns -- equations)
%--- IRFs in response to a monetary policy shock for nonstate banks.
scl_irfs = -100; %percent
irfs_ARIX_BL_nonstate = imf3hat_nonstate(:,[loc_ARIXvar, loc_BLvar],loc_MPshock);
irfs_cum_ARIX_BL_nonstate = cumsum(irfs_ARIX_BL_nonstate, loc_MPshock);
irfs_cum_Tcredit_nonstate = irfs_cum_ARIX_BL_nonstate(:,1) + irfs_cum_ARIX_BL_nonstate(:,2);
      
figure('PaperPosition',[0.25 1 7 8]); %[left bottom witdh height]  Tip: bottom + height = 10.0
subplot(3,1,1);
plot(1:imstp, irfs_cum_ARIX_BL_nonstate(:,1)*scl_irfs);
ylabel('ARIX');
grid;
subplot(3,1,2);
plot(1:imstp, irfs_cum_ARIX_BL_nonstate(:,2)*scl_irfs);
ylabel('Bank loans');
grid;
subplot(3,1,3);
plot(1:imstp, irfs_cum_Tcredit_nonstate*scl_irfs);
ylabel('Total credit');
grid;
subtitle('Cumulative new loans as percent of GDP (nonstate banks)');

%=== State banks
imfhat_state = fn_impulse(Bhat_state, A0hatinv_state, [nvar lags imstp]);    
imf3hat_state = reshape(imfhat_state,size(imfhat_state,1),nvar,nvar);
        % imf3: row--steps, column--nvar responses, 3rd dimension--nvar shocks
imf3shat_state = permute(imf3hat_state,[1 3 2]);
        % imf3s: permuted so that row--steps, column--nvar shocks,
        %                                3rd dimension--nvar responses
        % Note: reshape(imf3s(1,:,:),nvar,nvar) = A0in  (columns -- equations)
%scaleout
%--- IRFs in response to a monetary policy shock for state banks.
irfs_ARIX_BL_state = imf3hat_state(:,[loc_ARIXvar, loc_BLvar],loc_MPshock);
irfs_cum_ARIX_BL_state = cumsum(irfs_ARIX_BL_state, loc_MPshock);
irfs_cum_Tcredit_state = irfs_cum_ARIX_BL_state(:,1) + irfs_cum_ARIX_BL_state(:,2);
      

figure('PaperPosition',[0.25 1 7 8]); %[left bottom witdh height]  Tip: bottom + height = 10.0
subplot(3,1,1);
plot(1:imstp, irfs_cum_ARIX_BL_state(:,1)*scl_irfs);
ylabel('ARIX');
grid;
subplot(3,1,2);
plot(1:imstp, irfs_cum_ARIX_BL_state(:,2)*scl_irfs);
ylabel('Bank loans');
grid;
subplot(3,1,3);
plot(1:imstp, irfs_cum_Tcredit_state*scl_irfs);
ylabel('Total credit');
grid;
subtitle('Cumulative new loans as percent of GDP (state banks)');

%=== Aggregate --- the whole banking system
irfs_cum_ARIX_BL_all = irfs_cum_ARIX_BL_nonstate + irfs_cum_ARIX_BL_state;
irfs_cum_Tcredit_all = irfs_cum_Tcredit_nonstate + irfs_cum_Tcredit_state;
figure('PaperPosition',[0.25 1 7 8]); %[left bottom witdh height]  Tip: bottom + height = 10.0
subplot(3,1,1);
plot(1:imstp, irfs_cum_ARIX_BL_all(:,1)*scl_irfs);
ylabel('ARIX');
grid;
subplot(3,1,2);
plot(1:imstp, irfs_cum_ARIX_BL_all(:,2)*scl_irfs);
ylabel('Bank loans');
grid;
subplot(3,1,3);
plot(1:imstp, irfs_cum_Tcredit_all*scl_irfs);
ylabel('Total credit');
grid;
subtitle('Cumulative new loans as percent of GDP (all banks)');

