%================================================================================================================%
%============================= Inference and probability distribution of PVARs ==================================%
%================================================================================================================%
%* This program is based on: 
%*    Zha, 1999. ``Block Recursion and Structural Vector Autoregressions'', Journal of Econometrics (90), 291-316.
%*    Sims and Zha, 1999. ``Error Bands for Impulse Responses'', Econometrica (67), 1113-1155. 
%*    Waggoner and Zha, 2003. ``A Gibbs Sampler for Structural Vector Autoregressions'', Journal of Economic Dynamics and Control (28), 349-366.

pvar_est;  % starts the estimation, where everyhting is initialized through bvar_setup.m.


%---------- Preparations outside the Gibbs loop ------------
imfgbs_draws_nonstate = zeros(ndraws_mcmc, imstp*nvar^2);  % Storing draws of impulse responses.
imfgbs_draws_state = zeros(ndraws_mcmc, imstp*nvar^2);  % Storing draws of impulse responses.
%--- For A0's (general)
n0cum = [0;cumsum(n0)];

%============== Nonstate banks ===================
%*** For A0's
H0sqr_inv_nonstate = zeros(n0cum(end));  % inv(sqrt(H0)) where H) has NOT divided by T.
cTinv_nonstate = cell(nvar,1);   % in each cell, inv(T_i) for T_iT_i'=H0_i in the proof of Theorem 1 in the WZ paper
UT_nonstate = cell(nvar,1);  % in each cell, U_i*T_i in the proof of Theorem 1
for k=1:nvar
   cTinv_nonstate{k} = chol(H0inv_nonstate{k}/fss_nonstate);   % upper triangular Choleski for H0inv but lower triangular Choleski to H0inv
   UT_nonstate{k} = Ui{k}/cTinv_nonstate{k};    % n-by-qi: U_i*T_i in the proof of Theorem 1
   %
   H0sqr_inv_nonstate(n0cum(k)+1:n0cum(k+1),n0cum(k)+1:n0cum(k+1)) = cTinv_nonstate{k}*sqrt(fss_nonstate);
end
%*** For A+'s
VHphalf_nonstate = cell(nvar,1);  % in each cell, V_i*sqrt(Hp_i).
PU_nonstate = cell(nvar,1);  % in each cell, P_i*U_i
VPU_nonstate = cell(nvar,1);  % in each cell, V_i*P_i*U_i
for ki=1:nvar
   VHphalf_nonstate{ki} = Vi{ki}/chol(Hpinv_nonstate{ki}); % where chol(Hpinv_i)*chol(Hpinv_i)'=Hpinv_i.
   PU_nonstate{ki} = Pmat_nonstate{ki}*Ui{ki}';
   VPU_nonstate{ki} = Vi{ki}*PU_nonstate{ki};
end

%============== State banks ===================
%*** For A0's
H0sqr_inv_state = zeros(n0cum(end));  % inv(sqrt(H0)) where H) has NOT divided by T.
cTinv_state = cell(nvar,1);   % in each cell, inv(T_i) for T_iT_i'=H0_i in the proof of Theorem 1 in the WZ paper
UT_state = cell(nvar,1);  % in each cell, U_i*T_i in the proof of Theorem 1
for k=1:nvar
   cTinv_state{k} = chol(H0inv_state{k}/fss_state);   % upper triangular Choleski for H0inv but lower triangular Choleski to H0inv
   UT_state{k} = Ui{k}/cTinv_state{k};    % n-by-qi: U_i*T_i in the proof of Theorem 1
   %
   H0sqr_inv_state(n0cum(k)+1:n0cum(k+1),n0cum(k)+1:n0cum(k+1)) = cTinv_state{k}*sqrt(fss_state);
end
%*** For A+'s
VHphalf_state = cell(nvar,1);  % in each cell, V_i*sqrt(Hp_i).
PU_state = cell(nvar,1);  % in each cell, P_i*U_i
VPU_state = cell(nvar,1);  % in each cell, V_i*P_i*U_i
for ki=1:nvar
   VHphalf_state{ki} = Vi{ki}/chol(Hpinv_state{ki}); % where chol(Hpinv_i)*chol(Hpinv_i)'=Hpinv_i.
   PU_state{ki} = Pmat_state{ki}*Ui{ki}';
   VPU_state{ki} = Vi{ki}*PU_state{ki};
end

%------------------- Gibbs sampling ---------------------
%*** Initial draw of A0 at ML
A0gbs_nonstate = A0hat_nonstate;   % from "load ..."
A0gbs_nonstate = A0hat_nonstate*nbanks_nonstate;   % A0's from the Gibbs sampling. Returning to the original A0hat without scaling or aggregating.
Apgbs_nonstate = Aphat_nonstate;  % initialize A+
A0gbs_state = A0hat_state*nbanks_state;   % A0's from the Gibbs sampling. Returning to the original A0hat without scaling or aggregating.
Apgbs_state = Aphat_state;  % initialize A+

tic;
%*****************************************************************
%*** First set of draws of A0 and A+ to be burned in for Gibbs sampling
%*****************************************************************
for draws = 1:ndraws_burnin
   %*** A Gibbs draw of A0
   A0gbs_nonstate = fn_gibbsrvar(A0gbs_nonstate, UT_nonstate, nvar, fss_nonstate, n0, [1:nvar]);
   A0gbs_nonstate = nmlzvar(A0gbs_nonstate, A0hat_nonstate, [], IndxNmlr,0,[]);  % normalization
   A0gbs_state = fn_gibbsrvar(A0gbs_state, UT_state, nvar, fss_state, n0, [1:nvar]);
   A0gbs_state = nmlzvar(A0gbs_state, A0hat_state, [], IndxNmlr,0,[]);  % normalization
   %*** A normal draw of A+ conditional on A0gbs
   for kj=[1:nvar]
      Apgbs_nonstate(:,kj) = VPU_nonstate{kj}*A0gbs_nonstate(:,kj) + VHphalf_nonstate{kj}*randn(np(kj),1);   % A+
      Apgbs_state(:,kj) = VPU_state{kj}*A0gbs_state(:,kj) + VHphalf_state{kj}*randn(np(kj),1);   % A+
   end
end

%*****************************************************************
%*** Second set of draws of A0 and A+ to be kept for Gibbs sampling
%*****************************************************************
dispdraw = [];
for (k=1:10)
   dispdraw = [dispdraw, ceil(ndraws_mcmc/10)*k]; 
end
drawi = 0;
starttime = tic;
while (drawi<ndraws_mcmc)
   drawi = drawi + 1;
   if find(drawi == dispdraw)
       fprintf('%d%% of %d Gibbs draws finished\n', (drawi/ndraws_mcmc*100), ndraws_mcmc);
   end
   
   %*** A Gibbs draw of A0
   A0gbs_nonstate = fn_gibbsrvar(A0gbs_nonstate, UT_nonstate, nvar, fss_nonstate, n0, [1:nvar]);
   A0gbs_nonstate = nmlzvar(A0gbs_nonstate, A0hat_nonstate, [], IndxNmlr,0,[]);  % normalization
   A0gbs_state = fn_gibbsrvar(A0gbs_state, UT_state, nvar, fss_state, n0, [1:nvar]);
   A0gbs_state = nmlzvar(A0gbs_state, A0hat_state, [], IndxNmlr,0,[]);  % normalization
   %*** A normal draw of A+ conditional on A0gbs
   for kj=[1:nvar]
      Apgbs_nonstate(:,kj) = VPU_nonstate{kj}*A0gbs_nonstate(:,kj) + VHphalf_nonstate{kj}*randn(np(kj),1);   % A+
      Apgbs_state(:,kj) = VPU_state{kj}*A0gbs_state(:,kj) + VHphalf_state{kj}*randn(np(kj),1);   % A+
   end
   
   %-----------------------------------------------------------
   %--- Draws of impulse responses
   %-----------------------------------------------------------
   A0gbs_nonstate_agg = A0gbs_nonstate;
   A0gbs_nonstate_agg(:, loc_MPshock) = A0gbs_nonstate_agg(:, loc_MPshock)/nbanks_nonstate;
   Apgbs_nonstate_agg = Apgbs_nonstate;
   Apgbs_nonstate_agg(:, loc_MPshock) = Apgbs_nonstate_agg(:, loc_MPshock)/nbanks_nonstate;
   swish_nonstate_agg = inv(A0gbs_nonstate_agg); %scaling to the aggregate nonstate banking sector.
   Bgbs_nonstate_agg = Apgbs_nonstate_agg*swish_nonstate_agg;   % ncoef-by-nvar reduced form lagged parameters.
   imfgbs_nonstate = fn_impulse(Bgbs_nonstate_agg, swish_nonstate_agg, [nvar lags imstp]);
               % imstp-by-nvar^2 in the form that is congenial to RATS and
               % in the order of nvar responses to 1st shock; nvar responses to 2nd shock, etc.
   imfgbs_draws_nonstate(drawi,:) = imfgbs_nonstate(:)';
   %---
   A0gbs_state_agg = A0gbs_state;
   A0gbs_state_agg(:, loc_MPshock) = A0gbs_state_agg(:, loc_MPshock)/nbanks_state;
   Apgbs_state_agg = Apgbs_state;
   Apgbs_state_agg(:, loc_MPshock) = Apgbs_state_agg(:, loc_MPshock)/nbanks_state;   
   swish_state_agg = inv(A0gbs_state_agg); %scaling to the aggregate state banking sector.
   Bgbs_state_agg = Apgbs_state_agg*swish_state_agg;   % ncoef-by-nvar reduced form lagged parameters.
   imfgbs_state = fn_impulse(Bgbs_state_agg, swish_state_agg, [nvar lags imstp]);
               % imstp-by-nvar^2 in the form that is congenial to RATS and
               % in the order of nvar responses to 1st shock; nvar responses to 2nd shock, etc.
   imfgbs_draws_state(drawi,:) = imfgbs_state(:)';
end
disp('********* Minutes for completing the Gibbs sampling: ************')
timeminutes4Gibbs=toc(starttime)/60


%-----------------------------------------------------------
%--- Probability bands of impulse responses
%-----------------------------------------------------------
%========== Nonstate banks
imf_demarcated_nonstate = prctile(imfgbs_draws_nonstate, [5 16 50 84 95],1);
imferrl_nonstate = imf_demarcated_nonstate(1,:)';
imferrl1_nonstate = imf_demarcated_nonstate(2,:)';
imfmedian_nonstate = imf_demarcated_nonstate(3,:)';
imferrh1_nonstate = imf_demarcated_nonstate(4,:)';
imferrh_nonstate = imf_demarcated_nonstate(5,:)';
%*** Plot impulse responses
imferrl_nonstate = reshape(imferrl_nonstate, imstp,nvar^2);
imferrh_nonstate = reshape(imferrh_nonstate, imstp,nvar^2);
imfmedian_nonstate = reshape(imfmedian_nonstate, imstp,nvar^2);
imferrl1_nonstate = reshape(imferrl1_nonstate, imstp,nvar^2);
imferrh1_nonstate = reshape(imferrh1_nonstate,imstp,nvar^2);
%========== State banks
imf_demarcated_state = prctile(imfgbs_draws_state, [5 16 50 84 95],1);
imferrl_state = imf_demarcated_state(1,:)';
imferrl1_state = imf_demarcated_state(2,:)';
imfmedian_state = imf_demarcated_state(3,:)';
imferrh1_state = imf_demarcated_state(4,:)';
imferrh_state = imf_demarcated_state(5,:)';
%*** Plot impulse responses
imferrl_state = reshape(imferrl_state, imstp,nvar^2);
imferrh_state = reshape(imferrh_state, imstp,nvar^2);
imfmedian_state = reshape(imfmedian_state, imstp,nvar^2);
imferrl1_state = reshape(imferrl1_state, imstp,nvar^2);
imferrh1_state = reshape(imferrh1_state,imstp,nvar^2);


%-----------------------------------------------------------
%--- Probability bands for ad hoc objects
%-----------------------------------------------------------
scl_irfs = 100; 
%--- Impulse responses (cumulative).
imfgbs3_draws_nonstate = reshape(imfgbs_draws_nonstate, ndraws_mcmc, imstp, nvar, nvar);
    %gbs3: 1st: ndraws, 2nd: steps, 3rd: nvar responses, 4th: nvloc_ARIXvarar shocks
imfgbs3_cum_draws_nonstate = cumsum(imfgbs3_draws_nonstate, 2);
imfgbs3_cum_Tcredit_draws_nonstate = sum(imfgbs3_cum_draws_nonstate(:,:,[loc_ARIXvar, loc_BLvar],:),3);
%
imfgbs3_draws_state = reshape(imfgbs_draws_state, ndraws_mcmc, imstp, nvar, nvar);
    %gbs3: 1st: ndraws, 2nd: steps, 3rd: nvar responses, 4th: nvloc_ARIXvarar shocks
imfgbs3_cum_draws_state = cumsum(imfgbs3_draws_state, 2);
imfgbs3_cum_Tcredit_draws_state = sum(imfgbs3_cum_draws_state(:,:,[loc_ARIXvar, loc_BLvar],:),3);
%
imfgbs3_cum_draws_all = cumsum(imfgbs3_draws_nonstate+imfgbs3_draws_state, 2); %Aggregate.
imfgbs3_cum_Tcredit_draws_all = sum(imfgbs3_cum_draws_all(:,:,[loc_ARIXvar, loc_BLvar],:),3); %Aggregate.


%--- Demarcations of impulse responses.
imf3_cum_demarcated_nonstate = prctile(imfgbs3_cum_draws_nonstate,[5 16 50 84 95],1);
imferrl3_cum_nonstate  = squeeze(imf3_cum_demarcated_nonstate(2,:,:,:));
imfmedian_cum_nonstate = squeeze(imf3_cum_demarcated_nonstate(3,:,:,:));
imferrh3_cum_nonstate  = squeeze(imf3_cum_demarcated_nonstate(4,:,:,:));
%
imf3_cum_Tcredit_demarcated_nonstate = prctile(imfgbs3_cum_Tcredit_draws_nonstate,[5 16 50 84 95],1);
imferrl3_cum_Tcredit_nonstate  = squeeze(imf3_cum_Tcredit_demarcated_nonstate(2,:,:,:));
imfmedian_cum_Tcredit_nonstate = squeeze(imf3_cum_Tcredit_demarcated_nonstate(3,:,:,:));
imferrh3_cum_Tcredit_nonstate  = squeeze(imf3_cum_Tcredit_demarcated_nonstate(4,:,:,:));
%---
imf3_cum_demarcated_state = prctile(imfgbs3_cum_draws_state,[5 16 50 84 95],1);
imferrl3_cum_state  = squeeze(imf3_cum_demarcated_state(2,:,:,:));
imfmedian_cum_state = squeeze(imf3_cum_demarcated_state(3,:,:,:));
imferrh3_cum_state  = squeeze(imf3_cum_demarcated_state(4,:,:,:));
%
imf3_cum_Tcredit_demarcated_state = prctile(imfgbs3_cum_Tcredit_draws_state,[5 16 50 84 95],1);
imferrl3_cum_Tcredit_state  = squeeze(imf3_cum_Tcredit_demarcated_state(2,:,:,:));
imfmedian_cum_Tcredit_state = squeeze(imf3_cum_Tcredit_demarcated_state(3,:,:,:));
imferrh3_cum_Tcredit_state  = squeeze(imf3_cum_Tcredit_demarcated_state(4,:,:,:));
%---
imf3_cum_demarcated_all = prctile(imfgbs3_cum_draws_all,[5 16 50 84 95],1);
imferrl3_cum_all  = squeeze(imf3_cum_demarcated_all(2,:,:,:));
imfmedian_cum_all = squeeze(imf3_cum_demarcated_all(3,:,:,:));
imferrh3_cum_all  = squeeze(imf3_cum_demarcated_all(4,:,:,:));
%
imf3_cum_Tcredit_demarcated_all = prctile(imfgbs3_cum_Tcredit_draws_all,[5 16 50 84 95],1);
imferrl3_cum_Tcredit_all  = squeeze(imf3_cum_Tcredit_demarcated_all(2,:,:,:));
imfmedian_cum_Tcredit_all = squeeze(imf3_cum_Tcredit_demarcated_all(3,:,:,:));
imferrh3_cum_Tcredit_all  = squeeze(imf3_cum_Tcredit_demarcated_all(4,:,:,:));

xlimrange = [1, 12];
%--- Plotting impulse responses with error bands for nonstate banks.
irfs_cum_ARIX_BL_nonstate_hat  = -irfs_cum_ARIX_BL_nonstate;
irfs_cum_ARIX_BL_nonstate_low  = -imferrl3_cum_nonstate(:,[loc_ARIXvar, loc_BLvar],loc_MPshock);
irfs_cum_ARIX_BL_nonstate_high = -imferrh3_cum_nonstate(:,[loc_ARIXvar, loc_BLvar],loc_MPshock);
%
irfs_cum_Tcredit_nonstate_hat  = -irfs_cum_ARIX_BL_nonstate(:,1) - irfs_cum_ARIX_BL_nonstate(:,2);
irfs_cum_Tcredit_nonstate_low  = -imferrl3_cum_Tcredit_nonstate(:,loc_MPshock);
irfs_cum_Tcredit_nonstate_high = -imferrh3_cum_Tcredit_nonstate(:,loc_MPshock);
%---
figure('PaperPosition',[0.25 1 7 8]); %[left bottom witdh height]  Tip: bottom + height = 10.0   
subplot(3,1,1);
plot(1:imstp, irfs_cum_ARIX_BL_nonstate_low(:,1)*scl_irfs, '--m','LineWidth',0.9);
hold on;          
plot(1:imstp, irfs_cum_ARIX_BL_nonstate_hat(:,1)*scl_irfs, '-k','LineWidth',0.5);
plot(1:imstp, irfs_cum_ARIX_BL_nonstate_high(:,1)*scl_irfs, '--m','LineWidth',0.9);   
hold off;
title('ARIX');
ylabel('Percent');
xlim(xlimrange);
grid;
subplot(3,1,2);
plot(1:imstp, irfs_cum_ARIX_BL_nonstate_low(:,2)*scl_irfs, '--m','LineWidth',0.9);
hold on;
plot(1:imstp, irfs_cum_ARIX_BL_nonstate_hat(:,2)*scl_irfs, '-k','LineWidth',0.5);
plot(1:imstp, irfs_cum_ARIX_BL_nonstate_high(:,2)*scl_irfs, '--m','LineWidth',0.9);   
hold off;
title('Bank loans');
ylabel('Percent');
xlim(xlimrange);
grid;
subplot(3,1,3);
plot(1:imstp, irfs_cum_Tcredit_nonstate_low*scl_irfs, '--m','LineWidth',0.9);
hold on;          
plot(1:imstp, irfs_cum_Tcredit_nonstate_hat*scl_irfs, '-k','LineWidth',0.5);
plot(1:imstp, irfs_cum_Tcredit_nonstate_high*scl_irfs, '--m','LineWidth',0.9);   
hold off;
title('Total credit');
ylabel('Percent');
xlim(xlimrange);
grid;
print -depsc2 outfig_loancum_nonstate.eps
print -dpdf   outfig_loancum_nonstate.pdf   


%--- Plotting impulse responses with error bands for state banks.
irfs_cum_ARIX_BL_state_hat  = -irfs_cum_ARIX_BL_state;
irfs_cum_ARIX_BL_state_low  = -imferrl3_cum_state(:,[loc_ARIXvar, loc_BLvar],loc_MPshock);
irfs_cum_ARIX_BL_state_high = -imferrh3_cum_state(:,[loc_ARIXvar, loc_BLvar],loc_MPshock);
%
irfs_cum_Tcredit_state_hat  = -irfs_cum_ARIX_BL_state(:,1) - irfs_cum_ARIX_BL_state(:,2);
irfs_cum_Tcredit_state_low  = -imferrl3_cum_Tcredit_state(:,loc_MPshock);
irfs_cum_Tcredit_state_high = -imferrh3_cum_Tcredit_state(:,loc_MPshock);
%---
figure('PaperPosition',[0.25 1 7 8]); %[left bottom witdh height]  Tip: bottom + height = 10.0   
subplot(3,1,1);
plot(1:imstp, irfs_cum_ARIX_BL_state_low(:,1)*scl_irfs, '--m','LineWidth',0.9);
hold on;          
plot(1:imstp, irfs_cum_ARIX_BL_state_hat(:,1)*scl_irfs, '-k','LineWidth',0.5);
plot(1:imstp, irfs_cum_ARIX_BL_state_high(:,1)*scl_irfs, '--m','LineWidth',0.9);   
hold off;
title('ARIX');
ylabel('Percent');
xlim(xlimrange);
grid;
subplot(3,1,2);
plot(1:imstp, irfs_cum_ARIX_BL_state_low(:,2)*scl_irfs, '--m','LineWidth',0.9);
hold on;
plot(1:imstp, irfs_cum_ARIX_BL_state_hat(:,2)*scl_irfs, '-k','LineWidth',0.5);
plot(1:imstp, irfs_cum_ARIX_BL_state_high(:,2)*scl_irfs, '--m','LineWidth',0.9);   
hold off;
title('Bank loans');
ylabel('Percent');
xlim(xlimrange);
grid;
subplot(3,1,3);
plot(1:imstp, irfs_cum_Tcredit_state_low*scl_irfs, '--m','LineWidth',0.9);
hold on;          
plot(1:imstp, irfs_cum_Tcredit_state_hat*scl_irfs, '-k','LineWidth',0.5);
plot(1:imstp, irfs_cum_Tcredit_state_high*scl_irfs, '--m','LineWidth',0.9);   
hold off;
title('Total credit');
ylabel('Percent');
xlim(xlimrange);
grid;
print -depsc2 outfig_loancum_state.eps
print -dpdf   outfig_loancum_state.pdf   

%--- Plotting impulse responses with error bands for all 16 banks.
%irfs_cum_ARIX_BL_all_hat  = -irfs_cum_ARIX_BL_all; %Posterior peak
irfs_cum_ARIX_BL_all_hat  = -imfmedian_cum_all(:,[loc_ARIXvar, loc_BLvar],loc_MPshock);    %Posterior median
irfs_cum_ARIX_BL_all_low  = -imferrl3_cum_all(:,[loc_ARIXvar, loc_BLvar],loc_MPshock);
irfs_cum_ARIX_BL_all_high = -imferrh3_cum_all(:,[loc_ARIXvar, loc_BLvar],loc_MPshock);
%
%irfs_cum_Tcredit_all_hat  = -irfs_cum_Tcredit_all;      %Posterior peak
irfs_cum_Tcredit_all_hat  = -imfmedian_cum_Tcredit_all(:,loc_MPshock); %Posterior median
irfs_cum_Tcredit_all_low  = -imferrl3_cum_Tcredit_all(:,loc_MPshock);
irfs_cum_Tcredit_all_high = -imferrh3_cum_Tcredit_all(:,loc_MPshock);
%---
figure('PaperPosition',[0.25 1 7 8]); %[left bottom witdh height]  Tip: bottom + height = 10.0   
subplot(3,1,1);
plot(1:imstp, irfs_cum_ARIX_BL_all_low(:,2)*scl_irfs, '--m','LineWidth',0.9);
hold on;
plot(1:imstp, irfs_cum_ARIX_BL_all_hat(:,2)*scl_irfs, '-k','LineWidth',1.2);
plot(1:imstp, irfs_cum_ARIX_BL_all_high(:,2)*scl_irfs, '--m','LineWidth',0.9);   
hold off;
title('Bank loans');
ylabel('Percent');
xlim(xlimrange);
grid;
subplot(3,1,2);
plot(1:imstp, irfs_cum_ARIX_BL_all_low(:,1)*scl_irfs, '--m','LineWidth',0.9);
hold on;          
plot(1:imstp, irfs_cum_ARIX_BL_all_hat(:,1)*scl_irfs, '-k','LineWidth',1.2);
plot(1:imstp, irfs_cum_ARIX_BL_all_high(:,1)*scl_irfs, '--m','LineWidth',0.9);   
hold off;
title('ARIX');
ylabel('Percent');
xlim(xlimrange);
grid;
subplot(3,1,3);
plot(1:imstp, irfs_cum_Tcredit_all_low*scl_irfs, '--m','LineWidth',0.9);
hold on;          
plot(1:imstp, irfs_cum_Tcredit_all_hat*scl_irfs, '-k','LineWidth',1.2);
plot(1:imstp, irfs_cum_Tcredit_all_high*scl_irfs, '--m','LineWidth',0.9);   
hold off;
title('Total credit');
ylabel('Percent');
xlim(xlimrange);
grid;
print -depsc2 outfigpaper_loancum_all.eps
print -dpdf   outfigpaper_loancum_all.pdf   
