% Converting the Excel data to ascii and Matlab files.
% <<>> ad hoc additions.

close all
clear all
clc
format short g

%===========================================
% Quarterly Data
%===========================================
q_m = 4;   % quarters or months
yrBin=2011;   % beginning of the year
qmBin=1;    % begining of the quarter or month
yrFin=2015;   % <<>>1 final year
qmFin=4;    % <<>>1 final quarter
nData=(yrFin-yrBin)*q_m - (q_m-qmFin) + (q_m-qmBin+1);  % total number of the available data -- this is all you have
qm_dates_data = ((yrBin+(qmBin-1)/4):1/4:(yrFin+(qmFin-1)/4))';
[xdd0,jnk] = xlsread('PanelData_BL_ARIX.xlsx','Nonstate banks');
nonstateloans = diff(xdd0(:,5:end));  %1-4: year, quarter, total bank loans, total ARIX
nbanks_nonstate = 11;
[xdd0,jnk] = xlsread('PanelData_BL_ARIX.xlsx','State banks');
stateloans = diff(xdd0(:,5:end));  %1-4: year, quarter, total bank loans, total ARIX
nbanks_state = 5;
nvars_nonstate = 2*nbanks_nonstate;
nvars_state = 2*nbanks_state;
[nt, ndv]=size(nonstateloans);
if nt~=(nData)
   warning(sprintf('nt=%d, Caution: not equal to the length in the Excel data',nt));
   return;
end
nbanks = nbanks_nonstate + nbanks_state;


%--- Copied and pasted from [qmdates4data, hz_data_q_struct.NominalGDPva_X11, xdd(:,75)] in  bvar_setup.m at /Users/tzha/Dropbox/ZhaProjects/China/_MonetaryPolicy/_Models/_Matlab201608NexusUsed/_EntrustedLoans
GDPmps0= [
  2011        11549   -0.0076925
2011.2        12069   0.00088299
2011.5        12491   -0.0008591
2011.8        12695    0.0078252
  2012        12990   -0.0083154
2012.2        13355    0.0030811
2012.5        13629    0.0038554
2012.8        13948  -0.00095754
  2013        14353    0.0083054
2013.2        14622   -0.0032496
2013.5        15023    -0.004287
2013.8        15393     0.001479
  2014        15594   -0.0014096
2014.2        15893    0.0025987
2014.5        16276    -0.016856
2014.8        16521    -0.010366
  2015        16663    -0.011839
2015.2        17018  -8.0823e-05
2015.5        17248     0.006718
2015.8        17526    -0.011116
];
GDP = GDPmps0(:,[2]);
mps = GDPmps0(:,[3]);

xdd_agg = zeros(nData, 3); %3: bank loans, ARIC, MP shocks
%---
xdd_nonstate = cell(nbanks_nonstate,1);
dtmp_nonstate = (nonstateloans ./ 1.0e+03) ./ repmat(GDP,[1,nvars_nonstate]); %Diff of loan levels and then divided by GDP
for (ik=1:nbanks_nonstate)
   xdd_nonstate{ik} = [dtmp_nonstate(:,((ik-1)*2+1):(ik*2)), mps];   %Adding the monetary policy shock series.
   xdd_agg = xdd_agg + xdd_nonstate{ik};
end   
%1. Bank loans
%2. ARIX
%3. Monetary policy shocks
clear dtmp_nonstate;
%-
xdd_state = cell(nbanks_state,1);
dtmp_state = (stateloans ./ 1.0e+03) ./ repmat(GDP,[1,nvars_state]); %Diff of loan levels and then divided by GDP
for (ik=1:nbanks_state)
   xdd_state{ik} = [dtmp_state(:,((ik-1)*2+1):(ik*2)), mps];   %Adding the monetary policy shock series.
   xdd_agg = xdd_agg + xdd_nonstate{ik};   
end   
%1. Bank loans
%2. ARIX
%3. Monetary policy shocks
clear dtmp_state;

vlist = [3, 2, 1]; 
varlist   = {'mps','arix','bl'};      
vlistlog  = [];        % subset of vlist.  Variables in log level so that differences are in growth, unlike R and U which are in annual percent (divided by 100 already).
vlistper  = [1:3];     % subset of vlist. Variables divided by 100, such as interest rates and the unemployment rate.
xlab      = varlist;   % shocks
rnum      = 3;         % number of rows in the graph
cnum      = 1;         % number of columns in the graph
indxC0Pres = 0;
idfile_const = 'ftd_iden_MPExoOnly2';   % identification (upper recursive in most cases)
%--- Locations
loc_MPshock = 1;
loc_ARIXeqn = 2; %ARIX equation
loc_BLeqn   = 3; %Bank-loan equation
loc_ARIXvar = 2; 
loc_BLvar   = 3;
%--- MCMC draws
nbuffer             = 2000;        % a block or buffer of draws that is reported on screen
ndraws_mcmc         = 5*nbuffer;  % number of parameter draws through MCMC.
ndraws_burnin       = floor(0.1*ndraws_mcmc); % number of parameter draws to be burned
tdf                 = 50;    % degrees of freedom for t-dist for initial draw of the MCMC loop


%%  ******* The specific sample range and related specifications
yrStart = 2011; 
qmStart = 1;
yrEnd   = 2015; 
qmEnd   = 4;
%
imstp   = 5*q_m;    % number of steps for impulse responses (e.g., 4 years)
nSample = (yrEnd-yrStart)*q_m + (qmEnd-qmStart+1);  % sample length (including lags)
qmdates4sample = ((yrStart+(qmStart-1)/q_m):1/q_m:(yrEnd+(qmEnd-1)/q_m))';  % quarterly or monthly dates for the sample (including lags)
nStart=(yrStart-yrBin)*q_m+qmStart-qmBin;  % positive number of months at the start
nEnd=(yrEnd-yrFin)*q_m+qmEnd-qmFin;     % negative number of months towards end
if ((nEnd>0) | (nStart<0))
   error('The specified sample is out of the bounds of the data!');
end
xdgel_nonstate = cell(nbanks_nonstate,1);
xdgel_state = cell(nbanks_state,1);
for (ik=1:nbanks_nonstate)
   xdgel_nonstate{ik} = xdd_nonstate{ik}(nStart+1:nData+nEnd,vlist);  %The sample time series used for estimation.
end
for (ik=1:nbanks_state)
   xdgel_state{ik} = xdd_state{ik}(nStart+1:nData+nEnd,vlist);  %The sample time series used for estimation.
end   
for (ik=1:nbanks_nonstate)
   baddata_nonstate = find(isnan(xdgel_nonstate{ik}));
   if ~isempty(baddata_nonstate)
      error('Some nonstate data for this selected sample are actually unavailable');
   end
end
for (ik=1:nbanks_state)
   baddata_state = find(isnan(xdgel_state{ik}));
   if ~isempty(baddata_state)
      error('Some state data for this selected sample are actually unavailable');
   end
end
%--
xdgel_agg = xdd_agg(nStart+1:nData+nEnd,vlist);


%%  ******* Model setup
nvar = length(vlist);  % number of endogneous variables
if ((rnum*cnum)<nvar)
   error('bvar_setup.m: rnum*cnum must be equal to or greater than nvar for plotting figures!');
end   
nexo = 1; % only constant term.  
if (nexo>1)
   error('You must rewrite the VAR model to make exogenous variables be a part of the whole VAR system');
end   
lags        = 4; % lag length
ess         = nSample - lags;              % effective sample size (ess), i.e, excluding lags.
qmdates4ess = qmdates4sample(lags+1:end);  % effective sample size (ess), i.e., without any lags.  
indxDummy = 0;     % 1: Sims-Zha prior by using dummy observations as an explicit prior fn_rnrprior_covres_dobs.m; 0: No Bayesian prior.
mu = zeros(6,1);   % initiating the quarterly or monthly values of hyperparameters for the Sims-Zha prior.
mu(1) = 5.0; %0.2; %0.2; %1.0; %1.0;
mu(2) = 5.0; %0.5; %0.5; %0.5; %0.5; %1.0;
mu(3) = 5.0;
mu(4) = 4.0;
mu(5) = 0.001;
mu(6) = 0.001;
% mu(1): overall tightness and also for A0;
% mu(2): relative tightness for A+;
% mu(3): relative tightness for the constant term;
% mu(4): tightness on lag decay;  (1)
% mu(5): weight on nvar sums of coeffs dummy observations (unit roots);
% mu(6): weight on single dummy initial observation including constant
%         (cointegration, unit roots, and stationarity);
seednumber = 9623; %27345;  % seed number for all random draws, including random initialization for minimization.  
if seednumber
   fn_reset_ini_seed(seednumber);
end
IndxNmlr = [1 0 0 0 0 0];  % imported by nmlzvar.m, see Hamilton, Waggoner, and Zha (2007, Econometric Review).  
    % Index for which normalization rule to choose
    % Only one of the elments in IndxNmlr can be non-zero
    % IndxNmlr(1): ML A distance rule (supposed to be the best)
    % IndxNmlr(2): ML Ahat distance rule (to approximate IndxNmlr(1))
    % IndxNmlr(3): ML Euclidean distance rule (not invariant to scale)
    % IndxNmlr(4): Positive diagonal rule
    % IndxNmlr(5): Positive inv(A) diagonal rule (if ~IndxNmlr(5), no need for A0inu,
    %                                      so let A0inu=[])
    % IndxNmlr(6): Assigned postive rule (such as off-diagonal elements). 





