****************************************************************************
* This code generates Table 6 and Table 7 in Chen, Ren, and Zha (2018)
* "THE NEXUS OF MONETARY POLICY AND SHADOW BANKING IN CHINA"
* Data source: 
* Bureau van Dijk. 2009-2015. " Bankscope."  (accessed December 2, 2016).
* Banks' annnual report. 
* Chang C., K. Chen, D. Waggoner, and T. Zha, 2015, ``Trends and Cycles in China's Macroeconomy''.Data 201509 version is downloaded via https://www.frbatlanta.org/cqer.aspx.
*****************************************************************************


*********************************************
* Summary of steps
* step1: Load data
* step2: Summary statistics for Table 6
* step3: Generate double interaction terms
* step4: Regression results for Table 7
*************************


**********************
* Variable Description:
* Logarix: Log value of ARIX
* Smallbankb: This variable returns 0 if the bank is a nonstate bank and 0 otherwise
* GDPVA: Annual change in GDP in the previous year.
*       [NominalGDPva(t)*GDPDeflator(t)-NominalGDPva(t-1)*GDPDeflator(t-1)]/NominalGDPva(t)*GDPDeflator(t)
*       The series is used in Chang C., K. Chen, D. Waggoner, and T. Zha, 2015, ``Trends and Cycles in China's Macroeconomy''.
*       Data 201509 version is downloaded via https://www.frbatlanta.org/cqer.aspx.     
* CPIMC: Annual change in the GDP deflator in the previous year
* MPY: Annual change in the exogenous M2 supply in the previous year.
* Liquid3: Liquidity ratio is the percentage of liquid assets to total assets.
* ROA: Return on asset is the ratio of total net income to total assets. 
* Lta: Log value of banks' total asset
* EA: The ratio of equity and asset
* NPL: Non-performing loan ratio
* LDR: End of year Loan to deposit ratio
* Ldr_avg: Average loan to deposit ratio

*************************

**************************************************************************************************
*Step 1: Load data. See online appendix for details of the construction of entrusted loan data
**************************************************************************************************
cd "E:\bank\data2\CRZ"

use bank_asset_dataset,clear
*generate bank id
egen bankid = group(bankname)
*declare panel
xtset bankid time

**************************************************************************************************
*Step 2: Summary statistics  
***************************************************************************************

*This is the summary statistics in Table 6
tabstat liquid3 roa lta ea npl ldr,stat(n mean median sd min max)

**************************************************************************************************
*Step 3: Generate double interation terms
**************************************************************************************************
gen mpy_liquid3=mpy*liquid3
gen mpy_roa=mpy*roa
gen mpy_lta=mpy*lta
gen mpy_ea=mpy*ea
gen mpy_npl=mpy*npl
gen mpy_ldr=mpy*ldr
gen mpy_ldr_avg=mpy*ldr_avg
gen mpy_smallbankb=mpy*smallbankb

**************************************************************************************************
*Step 4: Regression
**************************************************************************************************

***Table 7 column (1)***
xtreg logarix smallbankb mpy_smallbankb mpy cpimc gdpva,robust
lincom mpy + mpy_small


***Table 7 column (2)***
xtreg logarix smallbankb mpy_smallbankb mpy cpimc gdpva if !missing(liquid3) &!missing(roa) &!missing(ea) &!missing(npl) &!missing(ldr),robust
lincom mpy + mpy_small

***Table 7 column (3)***
xtreg logarix smallbankb mpy_smallbankb mpy cpimc gdpva liquid3 roa lta ea npl ldr mpy_liquid3 mpy_roa mpy_lta mpy_ea mpy_npl mpy_ldr ,robust

***Table 7 column (4)***
xtreg logarix smallbankb mpy_smallbankb mpy cpimc gdpva liquid3 roa lta ea npl ldr_avg mpy_liquid3 mpy_roa mpy_lta mpy_ea mpy_npl mpy_ldr_avg ,robust

