function varsMSA = fn_logSAseries(varsM, qm)
%varsM_SA = fn_SAseries(varsM, qm)
%Seasonally adjusted log(varsM) and then unlog it to get varsMSA.
%
%varsM: T X n matrix of n original series.
%varsMSA: T X n matrix of n seasonally adjusted series.

nobs  = size(varsM,1);
nvars = size(varsM,2);
%======================================================
%========== Seasonally adjusted log(series) ===========
%======================================================
varsMSA = varsM; %Initialization
for ki=[1:nvars]
   logtobesa = log(varsM(:,ki));
   %---$$## Setup 
   timetrend = [1:nobs]';
   constterm = ones(nobs,1);
   nyears_max = ceil(nobs/qm);
   SeasDumMat = kron(ones(nyears_max,1),eye(qm));
   SeasDumMat = SeasDumMat(1:nobs,:);  %$$##
   SeasDumMatTrunc = SeasDumMat(:,1:(qm-1));
   %--- Seasonally adjusting
   Xright = [constterm timetrend SeasDumMatTrunc];
   yleft = logtobesa(:,1);
   BetaOLS = regress(yleft,Xright);
   BetaSeas = [BetaOLS(3:end) ; 0] - sum(BetaOLS(3:end))/qm;
   yleftSA = yleft - SeasDumMat*BetaSeas;
   varsMSA(:,ki) = exp(yleftSA);   
end   
