function []=mtd_plot(res)
% PURPOSE: Graphic output of multivariate temporal disaggregation methods
% ------------------------------------------------------------
% SYNTAX: []=mtd_plot(res);
% ------------------------------------------------------------
% OUTPUT: plots of
%         - high frequency estimates
%         - z constraint and transversal aggregation
% ------------------------------------------------------------
% INPUT: res: structure generated by denton or difonzo programs
% ------------------------------------------------------------
% SEE ALSO: denton, denton_prop, difonzo, rossi, mtd_print

% written by:
%  Enrique M. Quilis
%  Macroeconomic Research Department
%  Ministry of Economy and Finance
%  Paseo de la Castellana, 162. Office 2.5-1.
%  28046 - Madrid (SPAIN)
%  <enrique.quilis@meh.es>

% Version 1.1 [August 2006]

y=res.y(1:res.n,:);
z=res.z(1:res.n,:);

t=1:res.n;
figure;
plot(t,sum(res.y'),'ro',t,z);
legend('Transversal aggregation','z: Transversal constraint',0);
e=100*((sum(y')')-z)./z;   % Final discrepancy
xlabel ('time'); 
figure;
plot(e);
title ('Final discrepancy (as % of z)');
axis ([0 res.n -1 1]);   
xlabel ('time'); 

[aux,M] = size(res.y); clear aux;

switch res.meth
case {'Multivariate Denton','Multivariate Rossi'}
   % Nothing to do 
case {'Multivariate Di Fonzo'}   
   y_li = res.y - res.d_y;           % Lower limit of high freq. estimate
   y_ls = res.y + res.d_y;           % Upper limit of high freq. estimate
end

for i=1:M
    figure;
    switch res.meth
        case {'Multivariate Denton','Proportional Multivariate Denton', ...
                'Multivariate Rossi'}
            plot(t,res.y(:,i),'b-');
        case {'Multivariate Di Fonzo'}
            plot(t,res.y(:,i),'b-',t,y_li(:,i),'r-',t,y_ls(:,i),'r-');
            % Setting limits to select indicators from matrix x
            title ('High frequency series');
            xlabel ('time');
    end
end

