function [] = mtd_print(res,file_sal)
% PURPOSE: Save output of multivariate temporal disaggregation methods
% ------------------------------------------------------------
% SYNTAX: mtd_print(res,file_sal);
% ------------------------------------------------------------
% OUTPUT: ASCII file with detailed output of Denton or 
% di Fonzo multivariate temporal disaggregation methods
% ------------------------------------------------------------
% INPUT: res: structure generated by denton or difonzo programs
%        file_sal: name of ASCII file for output
% ------------------------------------------------------------
% SEE ALSO: denton, difonzo, rossi, mtd_plot

% written by:
%  Enrique M. Quilis
%  Macroeconomic Research Department
%  Ministry of Economy and Finance
%  Paseo de la Castellana, 162. Office 2.5-1.
%  28046 - Madrid (SPAIN)
%  <enrique.quilis@meh.es>

% Version 2.1 [August 2006]

sep ='-------------------------------------------------------';
sep1='*******************************************************';

if (nargin == 1)
   fid = 1;
else 
   fid=fopen(file_sal,'w');
end

fprintf(fid,'\n ');
fprintf(fid,'%s \n',sep1);
fprintf(fid,' TEMPORAL DISAGGREGATION METHOD: %s \n ',res.meth);
fprintf(fid,'%s \n',sep1);
fprintf(fid,'%s\n',sep);
fprintf(fid,' Number of low-frequency observations  : %4d\n ',res.N );
fprintf(fid,'Frequency conversion                  : %4d\n ',res.sc );
fprintf(fid,'Number of high-frequency observations : %4d\n ',res.n );
fprintf(fid,'Number of extrapolations 	   		: %4d\n ',res.pred );
fprintf(fid,'%s\n',sep);

fprintf(fid,' Type of disaggregation: ');
switch res.ta
case 1
   fprintf(fid,'sum (flow). \n');
case 2
   fprintf(fid,'average (index). \n');
case 3
   fprintf(fid,'interpolation (stock last). \n');
case 4
   fprintf(fid,'interpolation (stock first). \n');
end; %of switch ta
fprintf(fid,'%s\n',sep);

switch res.meth
case {'Multivariate Rossi'}
   fprintf(fid,' Preliminary univariate disaggregation: ');
   switch res.type
   case 1
      fprintf(fid,' Fernandez \n');
   case 2
      fprintf(fid,' Chow-Lin \n');
   case 3
      fprintf(fid,' Litterman \n');
   end
case {'Multivariate Denton'}
   fprintf(fid,' Degree of differencing                : %4d\n ',res.d );
case {'Multivariate di Fonzo'}
   fprintf(fid,' Model for the innovations: ');
   switch res.type
   case 0
      fprintf(fid,'white noise. \n');
   case 1
      fprintf(fid,'random walk. \n');
   end
end
fprintf(fid,'%s \n',sep);
fprintf(fid,'Elapsed time: %8.4f\n ',res.et);

if (nargin == 1)
   % Do nothing
else 
   fclose(fid);
end

