function Q = adaptstp (f, a, b, fa, fm, fb, is, trace, varargin)
%ADAPTSTP  Recursive function used by ADAPT.
%
%   Q = ADAPTSTP('F',A,B,FA,FM,FB,IS,TRACE) tries to
%   approximate the integral of f(x) from a to b to within a
%   relative error of IS/int(..)*eps.  F is a string containing
%   the name of f.  The remaining arguments are generated by adapt
%   or by the recursion.
%
%   See also ADAPT.

%   Author: Walter Gander, 05/20/97
% Copyright (C) 1997 Walter Gander
%
% This file is part of Dynare.
%
% Dynare is free software: you can redistribute it and/or modify
% it under the terms of the GNU General Public License as published by
% the Free Software Foundation, either version 3 of the License, or
% (at your option) any later version.
%
% Dynare is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
% GNU General Public License for more details.
%
% You should have received a copy of the GNU General Public License
% along with Dynare.  If not, see <http://www.gnu.org/licenses/>.

m = (a + b)/2; h = (b - a)/4;
x = [a + h, b - h];
y = feval(f, x, varargin{:});
fml = y(1); fmr = y(2);
i1 = h/1.5 * (fa + 4*fm + fb);
i2 = h/3 * (fa + 4*(fml + fmr) + 2*fm + fb);
i1 = (16*i2 - i1)/15;
if (is + (i1-i2) == is),
   Q = i1;
   if (trace), disp([a b-a Q]), end;
else
   Q = adaptstp (f, a, m, fa, fml, fm, is, trace, varargin{:}) + ...
      adaptstp (f, m, b, fm, fmr, fb, is, trace, varargin{:});
end;