****************************************************************************
* This code generates Table 4 and Table 5 in Chen, Ren, and Zha (2018)
* "THE NEXUS OF MONETARY POLICY AND SHADOW BANKING IN CHINA"
* Data source: 
* WIND. 2009-2015. " Entrusted Loan Announcements."  (accessed June 3, 2016).
* Bureau van Dijk. 2009-2015. " Bankscope."  (accessed December 2, 2016).
* Chang C., K. Chen, D. Waggoner, and T. Zha, 2015, ``Trends and Cycles in China's Macroeconomy''.Data 201509 version is downloaded via https://www.frbatlanta.org/cqer.aspx.
*****************************************************************************


*********************************************
* Summary of steps
* step1: Load data
* step2: Generate double interaction terms
* step3: Regression results for Table 4 and Table 5
*************************


**********************
* Variable Description:
* Log_sum_loan: Log value of total entrusted loan amount
* Log_avg_loan: Log value of average entrusted loan amount
* Bank: This variable returns 1 if he trustee is a bank and 0 otherwise
* Largebankb: This variable returns 1 if the bank is a state bank and 0 otherwise
* Smallbankb: This variable returns 0 if the bank is a nonstate bank and 0 otherwise
* GDPVA: Annual change in GDP in the previous year.
*       [NominalGDPva(t)*GDPDeflator(t)-NominalGDPva(t-1)*GDPDeflator(t-1)]/NominalGDPva(t)*GDPDeflator(t)
*       The series is used in Chang C., K. Chen, D. Waggoner, and T. Zha, 2015, ``Trends and Cycles in China's Macroeconomy''.
*       Data 201509 version is downloaded via https://www.frbatlanta.org/cqer.aspx.     
* CPIMC: Annual change in the GDP deflator in the previous year
* MPY: Annual change in the exogenous M2 supply in the previous year.
* Liquid3: Liquidity ratio is the percentage of liquid assets to total assets.
* ROA: Return on asset is the ratio of total net income to total assets. 
* Lta: Log value of banks' total asset
* EA: The ratio of equity and asset
* NPL: Non-performing loan ratio
* LDR: Loan to deposit ratio
*************************

**************************************************************************************************
*Step 1: Load data (See online appendix for details of the construction of entrusted loan data)
**************************************************************************************************
cd "E:\bank\data2\CRZ"

use entrusted_loan_dataset,clear
*generate trustee id

egen trusteeid = group(bankname)
*declear panel
xtset trusteeid time
**************************************************************************************************
*Step 2: Generate double interation terms
**************************************************************************************************
gen mpy_liquid3=mpy*liquid3
gen mpy_roa=mpy*roa
gen mpy_lta=mpy*lta
gen mpy_ea=mpy*ea
gen mpy_npl=mpy*npl
gen mpy_ldr=mpy*ldr
gen mpy_smallbankb=mpy*smallbankb
gen mpy_largebankb=mpy*largebankb

**************************************************************************************************
*Step 3: Regression results for Table 4 and Table 5
**************************************************************************************************


***Table 4 column (1)***
xtreg log_sum_loan  smallbankb mpy_smallbankb largebankb mpy_largebankb mpy cpimc gdpva,robust
lincom mpy + mpy_small
lincom mpy + mpy_largebankb


***Table 4 column (2)***
xtreg log_sum_loan  smallbankb mpy_smallbankb mpy cpimc gdpva if !missing(liquid3) &!missing(roa) &!missing(ea) &!missing(npl) &!missing(ldr),robust
lincom mpy + mpy_small


***Table 4 column (3)***
xtreg log_sum_loan  smallbankb mpy_smallbankb mpy liquid3 roa lta ea npl ldr  mpy_liquid3 mpy_roa mpy_lta mpy_ea mpy_npl mpy_ldr cpimc gdpva,robust


***Table 5 column (1)***
xtreg log_avg_loan   smallbankb mpy_smallbankb largebankb mpy_largebankb mpy cpimc gdpva,robust
lincom mpy + mpy_small
lincom mpy + mpy_largebankb


***Table 5 column (2)***
xtreg log_avg_loan   smallbankb mpy_smallbankb mpy cpimc gdpva if !missing(liquid3) &!missing(roa) &!missing(ea) &!missing(npl) &!missing(ldr),robust
lincom mpy + mpy_small


***Table 5 column (3)***
xtreg log_avg_loan   smallbankb mpy_smallbankb mpy liquid3 roa lta ea npl ldr  mpy_liquid3 mpy_roa mpy_lta mpy_ea mpy_npl mpy_ldr cpimc gdpva,robust


