function objfun = ftd_minuslogLH_mprule_tv(xhat, inpdatastr)
%=== xhat: 1: gamma0; 2: gammam; 3: gammapi; 4: gammaxa; 5: gammaxb; 6: sigmaa; 7: sigmab;
%inpdatastr.nSample          
%inpdatastr.M2gAt_qoq        
%inpdatastr.M2gAtm1_qoq      
%inpdatastr.CPIgtm1_qoq      
%inpdatastr.GDPgtm1_qoq      
%inpdatastr.GDPtargettm1_qoq 

nSample          = inpdatastr.nSample         ;
M2gAt_qoq        = inpdatastr.M2gAt_qoq       ;
M2gAtm1_qoq      = inpdatastr.M2gAtm1_qoq     ;
CPIgtm1_qoq      = inpdatastr.CPIgtm1_qoq     ;
GDPgtm1_qoq      = inpdatastr.GDPgtm1_qoq     ;
GDPtargettm1_qoq = inpdatastr.GDPtargettm1_qoq;
%- 
logp_em = 0.0;
for (ti=1:nSample)
   GDPgGaptm1 = GDPgtm1_qoq(ti)-GDPtargettm1_qoq(ti);
   if (GDPgGaptm1 >= 0.0)  %Normal regime
      emt = M2gAt_qoq(ti) - xhat(1) - xhat(2)*M2gAtm1_qoq(ti) - xhat(3)*CPIgtm1_qoq(ti) - xhat(4)*GDPgGaptm1;
      logp_emt = -0.5*log(2.0) - log(pi) - log(abs(xhat(6))) - emt^2/(2.0*xhat(6)^2);
   else %Shortfall regime
      emt = M2gAt_qoq(ti) - xhat(1) - xhat(2)*M2gAtm1_qoq(ti) - xhat(3)*CPIgtm1_qoq(ti) - xhat(5)*GDPgGaptm1;
      logp_emt = -0.5*log(2.0) - log(pi) - log(abs(xhat(7))) - emt^2/(2.0*xhat(7)^2);
   end
   logp_em = logp_em + logp_emt;
end
objfun = -logp_em;

