function g = ftd_minuslogLH_mprule_tv_grad1(xhat, inpdatastr)
%=== xhat: 1: gamma0; 2: gammam; 3: gammapi; 4: gammaxa; 5: gammaxb; 6: sigmaa; 7: sigmab;
%inpdatastr.nSample          
%inpdatastr.M2gAt_qoq        
%inpdatastr.M2gAtm1_qoq      
%inpdatastr.CPIgtm1_qoq      
%inpdatastr.GDPgtm1_qoq      
%inpdatastr.GDPtargettm1_qoq 

badg = 0.0;

nSample          = inpdatastr.nSample         ;
M2gAt_qoq        = inpdatastr.M2gAt_qoq       ;
M2gAtm1_qoq      = inpdatastr.M2gAtm1_qoq     ;
CPIgtm1_qoq      = inpdatastr.CPIgtm1_qoq     ;
GDPgtm1_qoq      = inpdatastr.GDPgtm1_qoq     ;
GDPtargettm1_qoq = inpdatastr.GDPtargettm1_qoq;
%- 
g  = zeros(length(xhat),1);
dx = zeros(length(xhat),1);
for (ti=1:nSample)
   GDPgGaptm1 = GDPgtm1_qoq(ti)-GDPtargettm1_qoq(ti);
   if (GDPgGaptm1 >= 0.0)  %Normal regime
      emt = M2gAt_qoq(ti) - xhat(1) - xhat(2)*M2gAtm1_qoq(ti) - xhat(3)*CPIgtm1_qoq(ti) - xhat(4)*GDPgGaptm1;
      dx(1) = emt/xhat(6)^2;
      dx(2) = (emt*M2gAtm1_qoq(ti))/xhat(6)^2;
      dx(3) = (emt*CPIgtm1_qoq(ti))/xhat(6)^2;
      dx(4) = (emt*GDPgGaptm1)/xhat(6)^2;
      dx(5) = 0.0;
      dx(6) = -1.0/abs(xhat(6)) + emt^2/xhat(6)^3;
      dx(7) = 0.0;
   else %Shortfall regime
      emt = M2gAt_qoq(ti) - xhat(1) - xhat(2)*M2gAtm1_qoq(ti) - xhat(3)*CPIgtm1_qoq(ti) - xhat(5)*GDPgGaptm1;
      dx(1) = emt/xhat(7)^2;
      dx(2) = (emt*M2gAtm1_qoq(ti))/xhat(7)^2;
      dx(3) = (emt*CPIgtm1_qoq(ti))/xhat(7)^2;
      dx(4) = 0.0;
      dx(5) = (emt*GDPgGaptm1)/xhat(7)^2;
      dx(6) = 0.0;
      dx(7) = -1.0/abs(xhat(7)) + emt^2/xhat(7)^3;
   end
   g = g - dx;
end


